// By EVOLVED
// www.evolved-software.com

//--------------
// tweaks
//--------------
   float2 ViewSize;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
	Texture=<RenderTexture>;
      };
   texture AdaptedLumTexture <string Name = " ";>;
   sampler AdaptedLumSampler=sampler_state 
      {
	Texture=<AdaptedLumTexture>;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Tex:TEXCOORD0;
	float4 Tex1:TEXCOORD1;
	float4 Tex2:TEXCOORD2;
	float4 Tex3:TEXCOORD3;
	float4 Tex4:TEXCOORD4;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos; 
  	OUT.Tex.xy=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize;
	OUT.Tex.zw=0.0;
	OUT.Tex1.xy=OUT.Tex.xy+float2(-ViewSize.x,0)*4;
	OUT.Tex1.zw=OUT.Tex.xy+float2(ViewSize.x,0)*4;
	OUT.Tex2.xy=OUT.Tex.xy+float2(0,-ViewSize.y)*4;
	OUT.Tex2.zw=OUT.Tex.xy+float2(0,ViewSize.y)*4;
	OUT.Tex3.xy=OUT.Tex.xy+float2(-ViewSize.x,-ViewSize.y)*4;
	OUT.Tex3.zw=OUT.Tex.xy+float2(ViewSize.x,ViewSize.y)*4;
	OUT.Tex4.xy=OUT.Tex.xy+float2(ViewSize.x,-ViewSize.y)*4;
	OUT.Tex4.zw=OUT.Tex.xy+float2(-ViewSize.x,ViewSize.y)*4;
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
	float2 LuminanceSum=tex2Dlod(RenderSampler,IN.Tex)
	                   +tex2Dlod(RenderSampler,IN.Tex1.xyyy)
	                   +tex2Dlod(RenderSampler,IN.Tex1.zwww)
	                   +tex2Dlod(RenderSampler,IN.Tex2.xyyy)
	                   +tex2Dlod(RenderSampler,IN.Tex2.zwww)
	                   +tex2Dlod(RenderSampler,IN.Tex3.xyyy)
	                   +tex2Dlod(RenderSampler,IN.Tex3.zwww)
	                   +tex2Dlod(RenderSampler,IN.Tex4.xyyy)
	                   +tex2Dlod(RenderSampler,IN.Tex4.zwww);
	return float4(LuminanceSum*0.111111,tex2Dlod(AdaptedLumSampler,IN.Tex).xy);		
     }

//--------------
// techniques   
//--------------
    technique Luminance
      {
 	pass p1
      {	
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
